/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.ConfigSpawning;
import com.lycanitesmobs.core.dungeon.instance.DungeonInstance;
import com.lycanitesmobs.core.entity.BossEntry;
import com.lycanitesmobs.core.mobevent.MobEvent;
import com.lycanitesmobs.core.mobevent.MobEventManager;
import com.lycanitesmobs.core.mobevent.MobEventPlayerClient;
import com.lycanitesmobs.core.mobevent.MobEventPlayerServer;
import com.lycanitesmobs.core.network.MessageMobEvent;
import com.lycanitesmobs.core.network.MessageWorldEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class ExtendedWorld
extends WorldSavedData {
    private static final String EXT_PROP_NAME = "LycanitesMobs";
    private static final Map<World, ExtendedWorld> loadedExtWorlds = new HashMap<World, ExtendedWorld>();
    public World world;
    public boolean initialized = false;
    public long lastSpawnerTime = 0L;
    public long lastEventScheduleTime = 0L;
    public long lastEventUpdateTime = 0L;
    public boolean useTotalWorldTime = true;
    public Map<String, MobEventPlayerServer> serverMobEventPlayers = new HashMap<String, MobEventPlayerServer>();
    public Map<String, MobEventPlayerClient> clientMobEventPlayers = new HashMap<String, MobEventPlayerClient>();
    public MobEventPlayerServer serverWorldEventPlayer = null;
    public MobEventPlayerClient clientWorldEventPlayer = null;
    private long worldEventStartTargetTime = 0L;
    private long worldEventLastStartedTime = 0L;
    private String worldEventName = "";
    private int worldEventCount = -1;
    public Map<UUID, BossEntry> bosses = new HashMap<UUID, BossEntry>();
    public Map<UUID, DungeonInstance> dungeons = new HashMap<UUID, DungeonInstance>();

    public static ExtendedWorld getForWorld(World world) {
        if (world == null) {
            return null;
        }
        return loadedExtWorlds.computeIfAbsent(world, k -> {
            ExtendedWorld worldExt;
            WorldSavedData worldSavedData = world.getPerWorldStorage().func_75742_a(ExtendedWorld.class, EXT_PROP_NAME);
            if (worldSavedData != null) {
                worldExt = (ExtendedWorld)worldSavedData;
                worldExt.world = world;
                worldExt.init();
            } else {
                worldExt = new ExtendedWorld(world);
                world.getPerWorldStorage().func_75745_a(EXT_PROP_NAME, (WorldSavedData)worldExt);
            }
            return worldExt;
        });
    }

    public static void remove(World world) {
        loadedExtWorlds.remove(world);
    }

    public ExtendedWorld(String prop_name) {
        super(EXT_PROP_NAME);
    }

    public ExtendedWorld(World world) {
        super(EXT_PROP_NAME);
        this.world = world;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.lastSpawnerTime = this.world.func_82737_E() - 1L;
        this.lastEventScheduleTime = this.world.func_82737_E() - 1L;
        this.lastEventUpdateTime = this.world.func_82737_E() - 1L;
        if (!this.world.field_72995_K && !"".equals(this.getWorldEventName()) && this.serverWorldEventPlayer == null) {
            long savedLastStartedTime = this.getWorldEventLastStartedTime();
            this.startMobEvent(this.getWorldEventName(), null, new BlockPos(0, 0, 0), 1, -1);
            if (this.serverWorldEventPlayer != null) {
                this.serverWorldEventPlayer.changeStartedWorldTime(savedLastStartedTime);
            }
        }
    }

    public void loadConfig() {
        ConfigSpawning config = ConfigSpawning.getConfig(LycanitesMobs.modInfo, "mobevents");
    }

    protected String getConfigEntryName(String name) {
        return name + " " + this.world.field_73011_w.func_186058_p().func_186065_b() + " (" + this.world.field_73011_w.getDimension() + ")";
    }

    public long getWorldEventStartTargetTime() {
        return this.worldEventStartTargetTime;
    }

    public long getWorldEventLastStartedTime() {
        return this.worldEventLastStartedTime;
    }

    public String getWorldEventName() {
        return this.worldEventName;
    }

    public MobEvent getWorldEvent() {
        if (this.getWorldEventName() == null || "".equals(this.getWorldEventName())) {
            return null;
        }
        return MobEventManager.getInstance().getMobEvent(this.getWorldEventName());
    }

    public int getWorldEventCount() {
        return this.worldEventCount;
    }

    public void setWorldEventStartTargetTime(long setLong) {
        if (this.worldEventStartTargetTime != setLong) {
            this.func_76185_a();
        }
        this.worldEventStartTargetTime = setLong;
        if (setLong > 0L) {
            LycanitesMobs.logDebug("MobEvents", "Next random mob will start after " + (this.worldEventStartTargetTime - this.world.func_82737_E()) / 20L + "secs.");
        }
    }

    public void setWorldEventLastStartedTime(long setLong) {
        if (this.worldEventLastStartedTime != setLong) {
            this.func_76185_a();
        }
        this.worldEventLastStartedTime = setLong;
    }

    public void setWorldEventName(String setString) {
        if (!this.worldEventName.equals(setString)) {
            this.func_76185_a();
        }
        this.worldEventName = setString;
    }

    public void increaseMobEventCount() {
        ++this.worldEventCount;
    }

    public int getRandomEventDelay(Random random) {
        int min = Math.max(200, MobEventManager.getInstance().minTicksUntilEvent);
        int max = Math.max(200, MobEventManager.getInstance().maxTicksUntilEvent);
        if (max <= min) {
            return min;
        }
        return min + random.nextInt(max - min);
    }

    public void startWorldEvent(MobEvent mobEvent) {
        boolean extended;
        if (mobEvent == null) {
            LycanitesMobs.logWarning("", "Tried to start a null world event, stopping any event instead.");
            this.stopWorldEvent();
            return;
        }
        if (!this.world.field_72995_K) {
            extended = false;
            if (this.serverWorldEventPlayer != null) {
                boolean bl = extended = this.serverWorldEventPlayer.mobEvent == mobEvent;
            }
            if (!extended) {
                this.serverWorldEventPlayer = mobEvent.getServerEventPlayer(this.world);
            }
            this.serverWorldEventPlayer.extended = extended;
            this.setWorldEventName(mobEvent.name);
            this.increaseMobEventCount();
            this.setWorldEventStartTargetTime(0L);
            this.setWorldEventLastStartedTime(this.world.func_82737_E());
            this.serverWorldEventPlayer.onStart();
            this.updateAllClientsEvents();
        }
        if (this.world.field_72995_K) {
            extended = false;
            if (this.clientWorldEventPlayer != null) {
                boolean bl = extended = this.clientWorldEventPlayer.mobEvent == mobEvent;
            }
            if (!extended) {
                this.clientWorldEventPlayer = mobEvent.getClientEventPlayer(this.world);
            }
            this.clientWorldEventPlayer.extended = extended;
            if (LycanitesMobs.proxy.getClientPlayer() != null) {
                this.clientWorldEventPlayer.onStart(LycanitesMobs.proxy.getClientPlayer());
            }
        }
    }

    public void stopWorldEvent() {
        if (this.serverWorldEventPlayer != null) {
            this.serverWorldEventPlayer.onFinish();
            this.setWorldEventName("");
            this.serverWorldEventPlayer = null;
            this.updateAllClientsEvents();
        }
        if (this.clientWorldEventPlayer != null) {
            if (LycanitesMobs.proxy.getClientPlayer() != null) {
                this.clientWorldEventPlayer.onFinish(LycanitesMobs.proxy.getClientPlayer());
            }
            this.clientWorldEventPlayer = null;
        }
    }

    public void startMobEvent(MobEvent mobEvent, EntityPlayer player, BlockPos pos, int level, int variant) {
        if (mobEvent == null) {
            LycanitesMobs.logWarning("", "Tried to start a null mob event.");
            return;
        }
        if (!this.world.field_72995_K) {
            MobEventPlayerServer mobEventPlayerServer = mobEvent.getServerEventPlayer(this.world);
            this.serverMobEventPlayers.put(mobEvent.name, mobEventPlayerServer);
            mobEventPlayerServer.player = player;
            mobEventPlayerServer.origin = pos;
            mobEventPlayerServer.level = level;
            mobEventPlayerServer.variant = variant;
            mobEventPlayerServer.onStart();
            this.updateAllClientsEvents();
        }
        if (this.world.field_72995_K) {
            MobEventPlayerClient mobEventPlayerClient;
            if (this.clientMobEventPlayers.containsKey(mobEvent.name)) {
                mobEventPlayerClient = this.clientMobEventPlayers.get(mobEvent.name);
            } else {
                mobEventPlayerClient = mobEvent.getClientEventPlayer(this.world);
                this.clientMobEventPlayers.put(mobEvent.name, mobEventPlayerClient);
            }
            if (LycanitesMobs.proxy.getClientPlayer() != null) {
                mobEventPlayerClient.onStart(LycanitesMobs.proxy.getClientPlayer());
            }
        }
    }

    public MobEvent startMobEvent(String mobEventName, EntityPlayer player, BlockPos pos, int level, int subspecies) {
        MobEvent mobEvent;
        if (MobEventManager.getInstance().mobEvents.containsKey(mobEventName)) {
            mobEvent = MobEventManager.getInstance().mobEvents.get(mobEventName);
            if (!mobEvent.isEnabled()) {
                LycanitesMobs.logWarning("", "Tried to start a mob event that was disabled with the name: '" + mobEventName + "' on " + (this.world.field_72995_K ? "Client" : "Server"));
                return null;
            }
        } else {
            LycanitesMobs.logWarning("", "Tried to start a mob event with the invalid name: '" + mobEventName + "' on " + (this.world.field_72995_K ? "Client" : "Server"));
            return null;
        }
        mobEvent.trigger(this.world, player, pos, level, subspecies);
        return mobEvent;
    }

    public void stopMobEvent(String mobEventName) {
        if (!this.world.field_72995_K && this.serverMobEventPlayers.containsKey(mobEventName)) {
            this.serverMobEventPlayers.get(mobEventName).onFinish();
            this.serverMobEventPlayers.remove(mobEventName);
            this.updateAllClientsEvents();
        }
        if (this.world.field_72995_K && this.clientMobEventPlayers.containsKey(mobEventName)) {
            if (LycanitesMobs.proxy.getClientPlayer() != null) {
                this.clientMobEventPlayers.get(mobEventName).onFinish(LycanitesMobs.proxy.getClientPlayer());
            }
            this.clientMobEventPlayers.remove(mobEventName);
        }
    }

    public MobEventPlayerServer getMobEventPlayerServer(String mobEventName) {
        if (mobEventName == null || "".equals(mobEventName)) {
            return null;
        }
        if (mobEventName.equals(this.getWorldEventName())) {
            return this.serverWorldEventPlayer;
        }
        if (this.serverMobEventPlayers.containsKey(mobEventName)) {
            return this.serverMobEventPlayers.get(mobEventName);
        }
        return null;
    }

    public MobEventPlayerClient getMobEventPlayerClient(String mobEventName) {
        if (mobEventName == null || "".equals(mobEventName)) {
            return null;
        }
        if (mobEventName.equals(this.worldEventName)) {
            return this.clientWorldEventPlayer;
        }
        if (this.clientMobEventPlayers.containsKey(mobEventName)) {
            return this.clientMobEventPlayers.get(mobEventName);
        }
        return null;
    }

    public void bossUpdate(Entity entity) {
        if (entity.func_70089_S()) {
            if (!this.bosses.containsKey(entity.func_110124_au())) {
                this.bosses.put(entity.func_110124_au(), new BossEntry());
            }
            this.bosses.get(entity.func_110124_au()).update(entity);
        }
    }

    public void overrideBossRange(Entity entity, int rangeOverride) {
        if (this.bosses.containsKey(entity.func_110124_au())) {
            this.bosses.get((Object)entity.func_110124_au()).nearbyRange = rangeOverride;
        }
    }

    public void bossRemoved(Entity entity) {
        this.bosses.remove(entity.func_110124_au());
    }

    public boolean isBossNearby(Vec3d pos) {
        for (BossEntry bossEntry : this.bosses.values()) {
            if (bossEntry == null || bossEntry.entity == null || !bossEntry.entity.func_70089_S() || !(bossEntry.entity.func_70092_e(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c) <= (double)(bossEntry.nearbyRange * bossEntry.nearbyRange))) continue;
            return true;
        }
        return false;
    }

    public void updateAllClientsEvents() {
        BlockPos pos = this.serverWorldEventPlayer != null ? this.serverWorldEventPlayer.origin : new BlockPos(0, 0, 0);
        int level = this.serverWorldEventPlayer != null ? this.serverWorldEventPlayer.level : 0;
        int subspecies = this.serverWorldEventPlayer != null ? this.serverWorldEventPlayer.variant : -1;
        MessageWorldEvent message = new MessageWorldEvent(this.getWorldEventName(), pos, level, subspecies);
        LycanitesMobs.packetHandler.sendToDimension(message, this.world.field_73011_w.getDimension());
        for (MobEventPlayerServer mobEventPlayerServer : this.serverMobEventPlayers.values()) {
            MessageMobEvent messageMobEvent = new MessageMobEvent(mobEventPlayerServer.mobEvent != null ? mobEventPlayerServer.mobEvent.name : "", mobEventPlayerServer.origin, mobEventPlayerServer.level, mobEventPlayerServer.variant);
            LycanitesMobs.packetHandler.sendToDimension(messageMobEvent, this.world.field_73011_w.getDimension());
        }
    }

    public void addDungeonInstance(DungeonInstance dungeonInstance, UUID uuid) {
        dungeonInstance.uuid = uuid;
        this.dungeons.put(dungeonInstance.uuid, dungeonInstance);
        this.func_76185_a();
    }

    public List<DungeonInstance> getNearbyDungeonInstances(ChunkPos chunkPos, int range) {
        ArrayList<DungeonInstance> nearbyDungeons = new ArrayList<DungeonInstance>();
        for (DungeonInstance dungeonInstance : this.dungeons.values()) {
            if (dungeonInstance.world == null) {
                dungeonInstance.init(this.world);
            }
            if (!dungeonInstance.isChunkPosWithin(chunkPos, range)) continue;
            nearbyDungeons.add(dungeonInstance);
        }
        return nearbyDungeons;
    }

    public void func_76184_a(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("WorldEventStartTargetTime")) {
            this.worldEventStartTargetTime = nbtTagCompound.func_74763_f("WorldEventStartTargetTime");
        }
        if (nbtTagCompound.func_74764_b("WorldEventLastStartedTime")) {
            this.worldEventLastStartedTime = nbtTagCompound.func_74763_f("WorldEventLastStartedTime");
        }
        if (nbtTagCompound.func_74764_b("WorldEventName")) {
            this.worldEventName = nbtTagCompound.func_74779_i("WorldEventName");
        }
        if (nbtTagCompound.func_74764_b("WorldEventCount")) {
            this.worldEventCount = nbtTagCompound.func_74762_e("WorldEventCount");
        }
        if (nbtTagCompound.func_74764_b("Dungeons")) {
            NBTTagList nbtDungeonList = nbtTagCompound.func_150295_c("Dungeons", 10);
            for (int i = 0; i < nbtDungeonList.func_74745_c(); ++i) {
                try {
                    NBTTagCompound dungeonNBT = nbtDungeonList.func_150305_b(i);
                    DungeonInstance dungeonInstance = new DungeonInstance();
                    dungeonInstance.readFromNBT(dungeonNBT);
                    if (dungeonInstance.uuid == null || this.dungeons.containsKey(dungeonInstance.uuid)) continue;
                    this.dungeons.put(dungeonInstance.uuid, dungeonInstance);
                    continue;
                }
                catch (Exception e) {
                    LycanitesMobs.logWarning("Dungeon", "An exception occurred when loading a dungeon from NBT.");
                }
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74772_a("WorldEventStartTargetTime", this.worldEventStartTargetTime);
        nbtTagCompound.func_74772_a("WorldEventLastStartedTime", this.worldEventLastStartedTime);
        nbtTagCompound.func_74778_a("WorldEventName", this.worldEventName);
        nbtTagCompound.func_74768_a("WorldEventCount", this.worldEventCount);
        NBTTagList nbtDungeonList = new NBTTagList();
        for (DungeonInstance dungeonInstance : this.dungeons.values()) {
            NBTTagCompound dungeonNBT = new NBTTagCompound();
            if ((dungeonNBT = dungeonInstance.writeToNBT(dungeonNBT)) == null) continue;
            nbtDungeonList.func_74742_a((NBTBase)dungeonNBT);
        }
        nbtTagCompound.func_74782_a("Dungeons", (NBTBase)nbtDungeonList);
        return nbtTagCompound;
    }
}

